package app.firezone.synk.network.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;


import java.util.ArrayList;

import app.firezone.synk.network.Activities.NotificationActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.NotificationLayoutBinding;
import app.firezone.synk.network.model.NotificationModel;

public class HomeNotificationAdapter extends RecyclerView.Adapter<HomeNotificationAdapter.holder> {
    Context mContext;
    ArrayList<NotificationModel> mlist = new ArrayList<>();

    public HomeNotificationAdapter(Context mContext, ArrayList<NotificationModel> mlist) {
        this.mContext = mContext;
        this.mlist = mlist;
    }


    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.notification_layout,parent,false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, @SuppressLint("RecyclerView") int position) {

        NotificationModel model = mlist.get(position);

        holder.binding.headText.setText(model.getHeadline());


        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                mContext.startActivity(new Intent(mContext, NotificationActivity.class));
            }
        });


    }

    @Override
    public int getItemCount() {
        return mlist.size();
    }

    public class holder extends RecyclerView.ViewHolder {

        NotificationLayoutBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);
            binding = NotificationLayoutBinding.bind(itemView);
        }
    }
}
